/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Implementation of the application main dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2015-12-03  Added selection of other connections than netXTransport

    2008-05-07  Fixed:
                - crash when closeing the App and a device was open
                Reason:
                - first close the App the Driver (xDriverClose) and than the Channel (xChannelClose)

    2007-07-10  Fixed:
                - crash when no device was selected during Open Device

    2006-06-28  initial version

**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifxTestDlg.h
///  Implementation of the application main dialog
///////////////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "cifXTestDlg.h"
#include "cifxuser.h"
#include "CifxErrors.h"
#include "CifxDeviceOpenDlg.h"
#include "CifXDeviceBase.h"
#include "BaseDialog.h"
#include "verinfo.h"
#include ".\cifxtestdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CCifXDeviceBase* CcifXTestDlg::s_pcDevice  = NULL;

static UINT s_auiStatusBarPanes[] =
{
  ID_STATUSBAR_PANE,
};

class CAboutDlg : public CDialog
{
public:
  CAboutDlg();

// Dialogfelddaten
  enum { IDD = IDD_ABOUTBOX };

  protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung

// Implementierung
protected:
  DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog();
};

/////////////////////////////////////////////////////////////////////////////
/// About Dialog Class
///
/////////////////////////////////////////////////////////////////////////////
CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

BOOL CAboutDlg::OnInitDialog()
{
  CDialog::OnInitDialog();

  CFileVersionInfo cVerInfo;
  cVerInfo.Open(AfxGetApp()->m_hInstance);

  TCHAR szData[MAX_PATH] = {0};
  //query product name
  if(cVerInfo.QueryStringValue(VI_STR_PRODUCTNAME, szData, sizeof(szData)/sizeof(TCHAR)))
    SetDlgItemText(IDC_STATIC_PROGRAMNAME, szData);
  else
    SetDlgItemText(IDC_STATIC_PROGRAMNAME, NULL);

  if(cVerInfo.QueryStringValue(VI_STR_COMPANYNAME, szData, sizeof(szData)/sizeof(TCHAR)))
    SetDlgItemText(IDC_STATIC_COMPANYNAME, szData);
  else
    SetDlgItemText(IDC_STATIC_COMPANYNAME, NULL);

  if(cVerInfo.QueryStringValue(VI_STR_FILEVERSION, szData, sizeof(szData)/sizeof(TCHAR)))
    SetDlgItemText(IDC_STATIC_VERSION, szData);
  else
    SetDlgItemText(IDC_STATIC_VERSION, NULL);

  if(cVerInfo.QueryStringValue(VI_STR_LEGALCOPYRIGHT, szData, sizeof(szData)/sizeof(TCHAR)))
    SetDlgItemText(IDC_STATIC_COPYRIGHT, szData);
  else
    SetDlgItemText(IDC_STATIC_COPYRIGHT, NULL);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
/// Helper function: get the selected API pointer
/////////////////////////////////////////////////////////////////////////////
CCifXAPIlib* CcifXTestDlg::GetSelectedAPI(void)
{
  if( m_cCifXAPICIFX.GetSelected())
    return &m_cCifXAPICIFX;

  if( m_cCifXAPInetXTransport.GetSelected())
    return &m_cCifXAPInetXTransport;

  if( m_cCifXAPInetXSPM.GetSelected())
    return &m_cCifXAPInetXSPM;

  return NULL;
}

/////////////////////////////////////////////////////////////////////////////
/// Helper function: Set the selected API pointer as checked
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::SetSelectedAPI(CCifXAPIlib* pcNewAPI)
{
  /* Check if new selection is already active */
  CCifXAPIlib* ptActAPI = GetSelectedAPI();

  if( NULL == ptActAPI)
  {
    /* No API selected, make the new one the actual one */
    pcNewAPI->SetSelected(true);

  } else if( ptActAPI != pcNewAPI)
  {
    /* Close an possible open device, Unselect the actual API */
    OnDeviceClose();
    ptActAPI->SetSelected(false);

    /* Select the new AP */
    pcNewAPI->SetSelected(true);

  }else
  {
    /* We are already selected */
  }
}

/////////////////////////////////////////////////////////////////////////////
/// CcifXTestDlg Class
/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent window
/////////////////////////////////////////////////////////////////////////////
CcifXTestDlg::CcifXTestDlg(CWnd* pParent /*=NULL*/)
  : CDialog(CcifXTestDlg::IDD, pParent)
  , m_pcActualDlg(NULL)
{
  m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CcifXTestDlg, CDialog)
  ON_WM_SYSCOMMAND()
  ON_WM_PAINT()
  ON_WM_QUERYDRAGICON()
  //}}AFX_MSG_MAP
  ON_COMMAND(ID_FILE_QUIT, OnFileQuit)
  ON_WM_DESTROY()
  ON_WM_INITMENUPOPUP()

  ON_COMMAND(ID__ABOUT, OnHelpAbout)

  ON_COMMAND(ID_DEVICE_OPEN, OnDeviceOpen)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_OPEN, OnUpdateDeviceOpen)

  ON_COMMAND(ID_DEVICE_CLOSE, OnDeviceClose)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_CLOSE, OnUpdateDeviceClose)

  ON_COMMAND(ID_DEVICE_RESET, OnDeviceReset)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_RESET, OnUpdateDeviceReset)

  ON_COMMAND(ID_INFORMATION_DRIVERINFORMATION, OnInformationDriverinformation)
  ON_UPDATE_COMMAND_UI(ID_INFORMATION_DRIVERINFORMATION, OnUpdateInformationDriverinformation)

  ON_COMMAND(ID_INFORMATION_CHANNELINFORMATION, OnInformationChannelinformation)
  ON_UPDATE_COMMAND_UI(ID_INFORMATION_CHANNELINFORMATION, OnUpdateInformationChannelinformation)

  ON_COMMAND(ID_DEVICE_WATCHDOG, OnDeviceWatchdog)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_WATCHDOG, OnUpdateDeviceWatchdog)

  ON_COMMAND(ID_DATATRANSFER_PACKETDATA, OnDatatransferPacketdata)
  ON_UPDATE_COMMAND_UI(ID_DATATRANSFER_PACKETDATA, OnUpdateDatatransferPacketdata)

  ON_COMMAND(ID_DATATRANSFER_I, OnDatatransferI)
  ON_UPDATE_COMMAND_UI(ID_DATATRANSFER_I, OnUpdateDatatransferI)

  ON_COMMAND(ID_DEVICE_HOSTSTATE, OnDeviceHoststate)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_HOSTSTATE, OnUpdateDeviceHoststate)

  ON_COMMAND(ID_DEVICE_BUSSTATE, OnDeviceBusstate)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_BUSSTATE, OnUpdateDeviceBusstate)

  ON_COMMAND(ID_DEVICE_DMASTATE, OnDeviceDMAstate)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_DMASTATE, OnUpdateDeviceDMAstate)

  ON_COMMAND(ID_DEVICE_CONFIGLOCK, OnDeviceConfiglock)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_CONFIGLOCK, OnUpdateDeviceConfiglock)

  ON_COMMAND(ID_DEVICE_DOWNLOAD, OnDeviceDownload)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_DOWNLOAD, OnUpdateDeviceDownload)

  ON_COMMAND(ID_INFORMATION_MAILBOXSTATE, OnInformationMailboxstate)
  ON_UPDATE_COMMAND_UI(ID_INFORMATION_MAILBOXSTATE, OnUpdateInformationMailboxstate)

  ON_COMMAND(ID_DEVICE_FILEEXPLORER, OnDeviceFileexplorer)
  ON_UPDATE_COMMAND_UI(ID_DEVICE_FILEEXPLORER, OnUpdateDeviceFileexplorer)

  ON_COMMAND(ID_REMOTEDEVICES_SETUP, OnRemotedevicesSetup)
  ON_UPDATE_COMMAND_UI(ID_REMOTEDEVICES_SETUP, OnUpdateRemotedevicesSetup)

  /* Dialog selection */
  ON_COMMAND(ID_SELECTCONNECTION_CIFX, OnCIFXSelect)
  ON_UPDATE_COMMAND_UI(ID_SELECTCONNECTION_CIFX, OnUpdateCIFXSelect)

  ON_COMMAND(ID_SELECTCONNECTION_NETXTRANSPORT, OnNetXTransportSelect)
  ON_UPDATE_COMMAND_UI(ID_SELECTCONNECTION_NETXTRANSPORT, OnUpdateNetXTransportSelect)

  ON_COMMAND(ID_SELECTCONNECTION_SPM, OnNetXSPMSelect)
  ON_UPDATE_COMMAND_UI(ID_SELECTCONNECTION_SPM, OnUpdateNetXSPMSelect)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/// First time dialog initialization
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CcifXTestDlg::OnInitDialog()
{
  CDialog::OnInitDialog();

  m_cPacketDlg.Create(CPacketDlg::IDD, this);
  m_cIoDlg.Create(CIOAccessDlg::IDD, this);
  m_cInfoDialog.Create(CInformationDialog::IDD, this);
  m_cWatchdogDlg.Create(CWatchdogDlg::IDD, this);
  m_cHostStateDlg.Create(CHostStateDlg::IDD, this);
  m_cBusStateDlg.Create(CBusStateDlg::IDD, this);
  m_cDMAStateDlg.Create(CDMAStateDlg::IDD, this);
  m_cDownloadDlg.Create(CDownloadDlg::IDD, this);
  m_cMailboxStateDlg.Create(CMailboxStateDlg::IDD, this);
  m_cResetDlg.Create(CResetDlg::IDD, this);
  m_cConfigLockDlg.Create(CConfigLockDlg::IDD, this);
  m_cFileExplorerDlg.Create(CFileExplorerDlg::IDD, this);

  // IDM_ABOUTBOX muss sich im Bereich der Systembefehle befinden.
  ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
  ASSERT(IDM_ABOUTBOX < 0xF000);

  CMenu* pSysMenu = GetSystemMenu(FALSE);
  if (pSysMenu != NULL)
  {
    CString strAboutMenu;
    strAboutMenu.LoadString(IDS_ABOUTBOX);
    if (!strAboutMenu.IsEmpty())
    {
      pSysMenu->AppendMenu(MF_SEPARATOR);
      pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
    }
  }

  // Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
  //  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
  SetIcon(m_hIcon, TRUE);     // Groes Symbol verwenden
  SetIcon(m_hIcon, FALSE);    // Kleines Symbol verwenden

  m_cStatusBar.Create(this);
  m_cStatusBar.SetIndicators(s_auiStatusBarPanes, sizeof(s_auiStatusBarPanes) / sizeof(s_auiStatusBarPanes[0]));

  CRect rectWindow;
  GetWindowRect(rectWindow);

  m_cStatusBar.SetPaneInfo(0, ID_STATUSBAR_PANE, SBPS_NORMAL, rectWindow.Width());

  long lRet = CIFX_NO_ERROR;


  AfxGetApp()->DoWaitCursor(1); // 1->>display the hourglass cursor

  /* Load available connection DLLs */
  /* Pre select the netXTransport DLL if available */
  if (CIFX_NO_ERROR == (lRet = m_cCifXAPInetXTransport.DriverOpen("netXTransport.dll")))
  {
    /* This os a library with a remote API setup */
    m_cCifXAPInetXTransport.SetRemoteAPI();

    m_cStatusBar.SetPaneText(0, _T("netXTransport - Successfully opened!"));
    m_cInfoDialog.SetDriverInfo(m_cCifXAPInetXTransport.DriverGetInformation());

    pSysMenu->EnableMenuItem( ID_SELECTCONNECTION_NETXTRANSPORT, TRUE);

    /* Set the netX Transport as the default API selection */
    SetSelectedAPI( &m_cCifXAPInetXTransport);

    CMenu* pMenu = GetMenu();
    pMenu->CheckMenuItem( ID_SELECTCONNECTION_NETXTRANSPORT, MF_CHECKED);

    m_cCifXAPInetXTransport.SetSelected( true);
  }

  AfxGetApp()->DoWaitCursor(1); // 1->>display the hourglass cursor

  /* Check if we have a netXSPMUSB DLL available */
  if (CIFX_NO_ERROR == (lRet = m_cCifXAPInetXSPM.DriverOpen("netXSPMUSB.dll")))
  {
    // Enable menu item if available
    pSysMenu->EnableMenuItem( ID_SELECTCONNECTION_SPM, TRUE);

    CCifXAPIlib* ptActApi = GetSelectedAPI();
    if( NULL == ptActApi)
    {
      /* No API selected, pre-select this one */
      m_cStatusBar.SetPaneText(0, _T("netXSPMUSB - Successfully opened!"));
      m_cInfoDialog.SetDriverInfo(m_cCifXAPInetXSPM.DriverGetInformation());

      pSysMenu->EnableMenuItem( ID_SELECTCONNECTION_SPM, TRUE);

      /* Set the netX Transport as the default API selection */
      SetSelectedAPI( &m_cCifXAPInetXSPM);

      CMenu* pMenu = GetMenu();
      pMenu->CheckMenuItem( ID_SELECTCONNECTION_SPM, MF_CHECKED);

      m_cCifXAPInetXSPM.SetSelected( true);
    }
  }

  AfxGetApp()->DoWaitCursor(1); // 1->>display the hourglass cursor

  /* Check if we have a CIFX32DLL available */
  if (CIFX_NO_ERROR == (lRet = m_cCifXAPICIFX.DriverOpen("cifX32DLL.dll")))
  {
    // Enable menu item if available
    pSysMenu->EnableMenuItem( ID_SELECTCONNECTION_CIFX, TRUE);

    CCifXAPIlib* ptActApi = GetSelectedAPI();
    if( NULL == ptActApi)
    {
      /* No API selected, pre-select this one */
      m_cStatusBar.SetPaneText(0, _T("CIFX Driver - Successfully opened!"));
      m_cInfoDialog.SetDriverInfo(m_cCifXAPICIFX.DriverGetInformation());

      pSysMenu->EnableMenuItem( ID_SELECTCONNECTION_CIFX, TRUE);

      /* Set the netX Transport as the default API selection */
      SetSelectedAPI( &m_cCifXAPICIFX);

      CMenu* pMenu = GetMenu();
      pMenu->CheckMenuItem( ID_SELECTCONNECTION_CIFX, MF_CHECKED);

      m_cCifXAPICIFX.SetSelected( true);
    }
  }

  RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, ID_STATUSBAR_PANE);

  AfxGetApp()->DoWaitCursor(-1); // -1->>remove the hourglass cursor

  return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

/////////////////////////////////////////////////////////////////////////////
/// OnSysCommand
///   \param nID
///   \param lParam
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
  if ((nID & 0xFFF0) == IDM_ABOUTBOX)
  {
    CAboutDlg dlgAbout;
    dlgAbout.DoModal();
  }
  else
  {
    CDialog::OnSysCommand(nID, lParam);
  }
}

/////////////////////////////////////////////////////////////////////////////
/// WM_PAINT message handler (support for minimized windows)
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnPaint()
{
  if (IsIconic())
  {
    CPaintDC dc(this); // Gertekontext zum Zeichnen

    SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

    // Symbol in Clientrechteck zentrieren
    int cxIcon = GetSystemMetrics(SM_CXICON);
    int cyIcon = GetSystemMetrics(SM_CYICON);
    CRect rect;
    GetClientRect(&rect);
    int x = (rect.Width() - cxIcon + 1) / 2;
    int y = (rect.Height() - cyIcon + 1) / 2;

    // Symbol zeichnen
    dc.DrawIcon(x, y, m_hIcon);
  }
  else
  {
    CDialog::OnPaint();
  }
}
/////////////////////////////////////////////////////////////////////////////
///  Fix for UPDATE_COMMAND_UI messages not properly being handled in Dialog
///   \param *pPopupMenu
///   \param nIndex
///   \param bSysMenu
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnInitMenuPopup(CMenu *pPopupMenu, UINT /*nIndex*/,BOOL /*bSysMenu*/)
{
  ASSERT(pPopupMenu != NULL);
  // Check the enabled state of various menu items.

  CCmdUI state;
  state.m_pMenu = pPopupMenu;
  ASSERT(state.m_pOther == NULL);
  ASSERT(state.m_pParentMenu == NULL);

  // Determine if menu is popup in top-level menu and set m_pOther to
  // it if so (m_pParentMenu == NULL indicates that it is secondary popup).
  HMENU hParentMenu;
  if (AfxGetThreadState()->m_hTrackingMenu == pPopupMenu->m_hMenu)
    state.m_pParentMenu = pPopupMenu;    // Parent == child for tracking popup.
  else if ((hParentMenu = ::GetMenu(m_hWnd)) != NULL)
  {
    CWnd* pParent = this;
    // Child windows don't have menus--need to go to the top!
    if (pParent != NULL &&
      (hParentMenu = ::GetMenu(pParent->m_hWnd)) != NULL)
    {
      int nIndexMax = ::GetMenuItemCount(hParentMenu);
      for (int nIndex = 0; nIndex < nIndexMax; nIndex++)
      {
        if (::GetSubMenu(hParentMenu, nIndex) == pPopupMenu->m_hMenu)
        {
          // When popup is found, m_pParentMenu is containing menu.
          state.m_pParentMenu = CMenu::FromHandle(hParentMenu);
          break;
        }
      }
    }
  }

  state.m_nIndexMax = pPopupMenu->GetMenuItemCount();
  for (state.m_nIndex = 0; state.m_nIndex < state.m_nIndexMax;
    state.m_nIndex++)
  {
    state.m_nID = pPopupMenu->GetMenuItemID(state.m_nIndex);
    if (state.m_nID == 0)
      continue; // Menu separator or invalid cmd - ignore it.

    ASSERT(state.m_pOther == NULL);
    ASSERT(state.m_pMenu != NULL);
    if (state.m_nID == (UINT)-1)
    {
      // Possibly a popup menu, route to first item of that popup.
      state.m_pSubMenu = pPopupMenu->GetSubMenu(state.m_nIndex);
      if (state.m_pSubMenu == NULL ||
        (state.m_nID = state.m_pSubMenu->GetMenuItemID(0)) == 0 ||
        state.m_nID == (UINT)-1)
      {
        continue;       // First item of popup can't be routed to.
      }
      state.DoUpdate(this, TRUE);   // Popups are never auto disabled.
    }
    else
    {
      // Normal menu item.
      // Auto enable/disable if frame window has m_bAutoMenuEnable
      // set and command is _not_ a system command.
      state.m_pSubMenu = NULL;
      state.DoUpdate(this, FALSE);
    }

    // Adjust for menu deletions and additions.
    UINT nCount = pPopupMenu->GetMenuItemCount();
    if (nCount < state.m_nIndexMax)
    {
      state.m_nIndex -= (state.m_nIndexMax - nCount);
      while (state.m_nIndex < nCount &&
        pPopupMenu->GetMenuItemID(state.m_nIndex) == state.m_nID)
      {
        state.m_nIndex++;
      }
    }
    state.m_nIndexMax = nCount;
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Returns the cursor that is to be used, when dragging minimized windows
///   \return Handle to usable cursor
/////////////////////////////////////////////////////////////////////////////
HCURSOR CcifXTestDlg::OnQueryDragIcon()
{
  return static_cast<HCURSOR>(m_hIcon);
}

/////////////////////////////////////////////////////////////////////////////
/// Filter messages to prevent dialog closing by keypress
/// (WM_KEYDOWN combined with VK_RETURN/VK_ESCAPE) will be filtered
///  \param pMsg Message to be checked for filtering
///  \return TRUE if the message should be filtered
/////////////////////////////////////////////////////////////////////////////
BOOL CcifXTestDlg::PreTranslateMessage(MSG* pMsg)
{
  if(pMsg->message == WM_KEYDOWN)
  {
    if( (pMsg->wParam == VK_RETURN) ||
        (pMsg->wParam == VK_ESCAPE) )
    {
      return TRUE;
    }
  }

  return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
/// Switches the display to the given Dialog
///   \param pcNewDialog Dialog to display
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::SetActiveDialog(CBaseDialog* pcNewDialog)
{
  CRect rectPlaceHolder;
  GetDlgItem(IDC_STATIC_PLACEHOLDER)->GetWindowRect(rectPlaceHolder);

  if(m_pcActualDlg)
  {
    m_pcActualDlg->ShowWindow(FALSE);
    m_pcActualDlg->SetThreadState(false);
    m_pcActualDlg->OnUpdateDevice(NULL);
    m_pcActualDlg = NULL;
  }

  ScreenToClient(rectPlaceHolder);

  m_pcActualDlg = pcNewDialog;

  if(NULL != m_pcActualDlg)
  {
    m_pcActualDlg->SetWindowPos(NULL,
                                rectPlaceHolder.left,
                                rectPlaceHolder.top,
                                rectPlaceHolder.Width(),
                                rectPlaceHolder.Height(),
                                SWP_SHOWWINDOW | SWP_NOZORDER);

    m_pcActualDlg->OnUpdateDevice(s_pcDevice);
    m_pcActualDlg->SetThreadState(true);
  }

}

/////////////////////////////////////////////////////////////////////////////
/// Dialog is being destroyed
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDestroy()
{
  CDialog::OnDestroy();

  SetActiveDialog(NULL);

  if(NULL != s_pcDevice)
  {
    delete s_pcDevice;
    s_pcDevice = NULL;
  }

  if(m_cCifXAPICIFX.Valid())
  {
    m_cCifXAPICIFX.DriverClose();
  }

  if(m_cCifXAPInetXTransport.Valid())
  {
    m_cCifXAPInetXTransport.DriverClose();
  }

  if(m_cCifXAPInetXSPM.Valid())
  {
    m_cCifXAPInetXSPM.DriverClose();
  }
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/// Menu: "File/Quit" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnFileQuit()
{
  EndDialog(0);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if Device/Open menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceOpen(CCmdUI *pCmdUI)
{
  //don't allow opening a Device if the driver is not available
  CCifXAPIlib* pcApi = GetSelectedAPI();

  if (NULL == pcApi)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Device/Open" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceOpen()
{
  CCifxDeviceOpenDlg cDlg;
  cDlg.AddDriverLib( GetSelectedAPI());

  if(cDlg.DoModal() == IDOK)
  {
    SetActiveDialog(NULL);

    if(NULL != s_pcDevice)
    {
      delete s_pcDevice;
      s_pcDevice = NULL;
    }

    if(NULL != (s_pcDevice = cDlg.GetSelectedDevice()))
    {
      long lRet = s_pcDevice->OpenDevice();

      if(lRet != CIFX_NO_ERROR)
      {
        CString csError;
        csError.Format(_T("Error opening device '%s'. Error=0x%08X, ('%s')!"),
                      s_pcDevice->GetDeviceName(), lRet, s_pcDevice->GetErrorDescription(lRet));
        AfxMessageBox(csError, MB_ICONERROR);
        m_cStatusBar.SetPaneText(0, csError);

        delete s_pcDevice;
        s_pcDevice = NULL;
      } else
      {
        CString csCaption;
        csCaption.LoadString(IDS_CAPTION_MAINWND);
        csCaption.AppendFormat(_T(" - %s"), s_pcDevice->GetDeviceName());
        SetWindowText(csCaption);
        if(NULL != m_pcActualDlg)
          m_pcActualDlg->OnUpdateDevice(s_pcDevice);
      }
    }
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Device/Close" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceClose(CCmdUI *pCmdUI)
{
  if( NULL != s_pcDevice)
    pCmdUI->Enable();
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Device/Close" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceClose()
{
  SetActiveDialog(NULL);

  delete s_pcDevice;
  s_pcDevice = NULL;

  CString csCaption;
  csCaption.LoadString(IDS_CAPTION_MAINWND);

  SetWindowText(csCaption);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Information/Driver Information" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateInformationDriverinformation(CCmdUI *pCmdUI)
{
  //don't allow querying driver information if the driver is not available
  CCifXAPIlib* pcAPI = GetSelectedAPI();

  if( NULL == pcAPI)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Information/Driver Information" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnInformationDriverinformation()
{
  m_cInfoDialog.SetType(CInformationDialog::eDRIVERINFO);

  SetActiveDialog(&m_cInfoDialog);

  m_cInfoDialog.UpdateValues();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Information/Channel Information" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateInformationChannelinformation(CCmdUI *pCmdUI)
{
  if( s_pcDevice)
    pCmdUI->Enable();
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Information/Channel Information" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnInformationChannelinformation()
{
  m_cInfoDialog.SetCaption(s_pcDevice->GetChannelInfoName());
  m_cInfoDialog.SetType(CInformationDialog::eCHANNELINFO);

  SetActiveDialog(&m_cInfoDialog);

  m_cInfoDialog.UpdateValues();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Data Transfer/Packet data" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDatatransferPacketdata(CCmdUI *pCmdUI)
{
  if( s_pcDevice)
    pCmdUI->Enable();
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Data Transfer/Packet Data" item clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDatatransferPacketdata()
{
  SetActiveDialog(&m_cPacketDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Data Transfer/I/OData" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDatatransferI(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Data Transfer/I/O Data" item clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDatatransferI()
{
  SetActiveDialog(&m_cIoDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "?/About" item clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnHelpAbout()
{
  CAboutDlg dlgAbout;
  dlgAbout.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
/// Checks if Device/Watchdog menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceWatchdog(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Device/Watchdog" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceWatchdog()
{
  SetActiveDialog(&m_cWatchdogDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Device/Host State" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceHoststate(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Device/Config Lock" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceConfiglock(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu:  "Device/Config Lock" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceConfiglock()
{
  SetActiveDialog(&m_cConfigLockDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Device/Host State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceHoststate()
{
  SetActiveDialog(&m_cHostStateDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Device/Bus State" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceBusstate(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Device/Bus State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceBusstate()
{
  SetActiveDialog(&m_cBusStateDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Device/DMA State" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceDMAstate(CCmdUI *pCmdUI)
{
  if( (NULL == s_pcDevice) || s_pcDevice->IsSystemDevice())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Device/DMA State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceDMAstate()
{
  SetActiveDialog(&m_cDMAStateDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Device/Download" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceDownload(CCmdUI *pCmdUI)
{
  if( NULL == s_pcDevice)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Device/Download" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceDownload()
{
  SetActiveDialog(&m_cDownloadDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Information/Mailbox State" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateInformationMailboxstate(CCmdUI *pCmdUI)
{
  if(NULL == s_pcDevice)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Information/Mailbox State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnInformationMailboxstate()
{
  SetActiveDialog(&m_cMailboxStateDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if Device/Reset menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceReset(CCmdUI *pCmdUI)
{
  if(s_pcDevice)
    pCmdUI->Enable();
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu "Device/Reset" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceReset()
{
  SetActiveDialog(&m_cResetDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Device/File Explorer" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateDeviceFileexplorer(CCmdUI *pCmdUI)
{
  if(NULL == s_pcDevice)
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable();
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Device/File Explorer" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnDeviceFileexplorer()
{
  SetActiveDialog(&m_cFileExplorerDlg);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: Checks if "Setup" menu item is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateRemotedevicesSetup(CCmdUI *pCmdUI)
{
  CCifXAPIlib* pcAPI = GetSelectedAPI();

  if( NULL != pcAPI)
    pCmdUI->Enable(pcAPI->IsRemoteAPI());
  else
    pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Setup" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnRemotedevicesSetup()
{
  CConnectorDlg cDlg( GetSelectedAPI());
  if(cDlg.DoModal() == IDOK)
  {
    SetActiveDialog(NULL);
  }
  // TODO: Add your command handler code here
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: check if "Select CIFX" menu is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateCIFXSelect(CCmdUI *pCmdUI)
{
  if( !m_cCifXAPICIFX.Valid())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Select CIIFX" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnCIFXSelect()
{
  CString csString;

  SetSelectedAPI( &m_cCifXAPICIFX);

  if( m_cCifXAPICIFX.Valid())
  {
    CMenu* pMenu = GetMenu();
    UINT ret  = pMenu->CheckMenuItem( ID_SELECTCONNECTION_CIFX, MF_CHECKED);
    if(  m_cCifXAPICIFX.IsRemoteAPI())
      ret = pMenu->EnableMenuItem( ID_REMOTEDEVICES_SETUP,  MF_ENABLED);
    else
      ret = pMenu->EnableMenuItem( ID_REMOTEDEVICES_SETUP,  MF_GRAYED);

    pMenu->CheckMenuItem( ID_SELECTCONNECTION_NETXTRANSPORT, MF_UNCHECKED);
    pMenu->CheckMenuItem( ID_SELECTCONNECTION_SPM, MF_UNCHECKED);

    m_cInfoDialog.SetDriverInfo(m_cCifXAPICIFX.DriverGetInformation());

    csString.Format(_T("CIFX Driver - Successfully opened"));
    m_cStatusBar.SetPaneText(0, csString);

  }else
  {
    csString.Format(_T("CIFX Driver - Error opening driver! Error=0x%08X"), m_cCifXAPICIFX.m_lError);
    m_cStatusBar.SetPaneText(0, csString);
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: check if "Select netXTransport" menu is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateNetXTransportSelect(CCmdUI *pCmdUI)
{
  if( !m_cCifXAPInetXTransport.Valid())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Select netXTransport" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnNetXTransportSelect()
{
  CString csString;

  SetSelectedAPI( &m_cCifXAPInetXTransport);

  if( m_cCifXAPInetXTransport.Valid())
  {
    CMenu* pMenu = GetMenu();
    pMenu->CheckMenuItem( ID_SELECTCONNECTION_NETXTRANSPORT, MF_CHECKED);
    if(  m_cCifXAPInetXTransport.IsRemoteAPI())
      pMenu->EnableMenuItem( ID_REMOTEDEVICES_SETUP,  MF_ENABLED | MF_BYCOMMAND);
    else
      pMenu->EnableMenuItem( ID_REMOTEDEVICES_SETUP,  MF_GRAYED | MF_BYCOMMAND);

    pMenu->CheckMenuItem( ID_SELECTCONNECTION_CIFX, MF_UNCHECKED);
    pMenu->CheckMenuItem( ID_SELECTCONNECTION_SPM, MF_UNCHECKED);

    m_cInfoDialog.SetDriverInfo(m_cCifXAPInetXTransport.DriverGetInformation());

    csString.Format(_T("netXTransport - Successfully opened"));
    m_cStatusBar.SetPaneText(0, csString);

  }else
  {
    csString.Format(_T("netXTransport - Error opening driver! Error=0x%08X"), m_cCifXAPInetXTransport.m_lError);
    m_cStatusBar.SetPaneText(0, csString);
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: check if "Select SPMUSB" menu is available
///   \param *pCmdUI
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnUpdateNetXSPMSelect(CCmdUI *pCmdUI)
{
  if( !m_cCifXAPInetXSPM.Valid())
    pCmdUI->Enable(FALSE);
  else
    pCmdUI->Enable(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
/// Menu: "Select SPMUSB" clicked event
/////////////////////////////////////////////////////////////////////////////
void CcifXTestDlg::OnNetXSPMSelect()
{
  CString csString;

  SetSelectedAPI( &m_cCifXAPInetXSPM);

  if( m_cCifXAPInetXSPM.Valid())
  {
    CMenu* pMenu = GetMenu();
    pMenu->CheckMenuItem( ID_SELECTCONNECTION_SPM, MF_CHECKED);

    if(  m_cCifXAPInetXSPM.IsRemoteAPI())
      pMenu->EnableMenuItem( ID_REMOTEDEVICES_SETUP,  MF_ENABLED | MF_BYCOMMAND);
    else
      pMenu->EnableMenuItem( ID_REMOTEDEVICES_SETUP,  MF_GRAYED | MF_BYCOMMAND);

    pMenu->CheckMenuItem( ID_SELECTCONNECTION_NETXTRANSPORT, MF_UNCHECKED);
    pMenu->CheckMenuItem( ID_SELECTCONNECTION_CIFX, MF_UNCHECKED);

    m_cInfoDialog.SetDriverInfo(m_cCifXAPInetXSPM.DriverGetInformation());

    csString.Format(_T("netXSPMUSB - Successfully opened"));
    m_cStatusBar.SetPaneText(0, csString);


  }else
  {
    csString.Format(_T("netXSPMUSB - Error opening driver! Error=0x%08X"), m_cCifXAPInetXSPM.m_lError);
    m_cStatusBar.SetPaneText(0, csString);
  }
}
